/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2026 i-net software GmbH, Berlin, Germany.
**/
package rdc;

import java.util.List;

import com.inet.report.DatabaseField;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.Fields;
import com.inet.report.Section;
import com.inet.report.TableSource;
import com.inet.report.TextPart;

/**
 * This sample shows how to add and use Joins between tables.
 */
public class Joins extends RDCSample {

    static final String MAINREPORT = "samples/rdc/nojoins.rpt";

    /**
     * Adds another database table and a join between the tables to an existing report.
     * @param exportFmt the output format (e.g. Engine.EXPORT_PDF)
     * @return the new engine for the report
     */
    @Override
    public Engine createAndFillEngine( String exportFmt ) {
        try {
            //create a new Engine
            Engine eng = new Engine( exportFmt );
            //set the name of the report file, that contain
            //Employee, EmployeeAdresses and a join between the EmployeeIDs 
            eng.setReportFile( MAINREPORT );

            //adding a third table to the data source
            Datasource ds = eng.getDatabaseTables().getDatasource( 0 );
            TableSource tsOrders = ds.createTableSource( "Orders" );
            tsOrders.addColumn( "EmployeeID", Field.NUMBER );
            tsOrders.addColumn( "PaymentReceived", Field.BOOLEAN );

            //add a join
            eng.getDatabaseTables().addJoin( "EmployeeAddresses", "EmployeeID", "Orders", "EmployeeID", DatabaseTables.JOINTYPE_INNER,
                                             DatabaseTables.JOINLINK_EQUALS );

            Section ph = eng.getArea( "PH" ).getSection( 0 );
            TextPart text = ph.addText( 5000, 0, 2000, 500 ).addParagraph().addTextPart( "Payment Received" );
            text.setBold( true );
            text.setUnderline( true );

            Section detail = eng.getArea( "D" ).getSection( 0 );
            Fields fields = eng.getFields();
            DatabaseField field = fields.getDatabaseField( "Orders.PaymentReceived" );
            detail.addFieldElement( field, 5000, 0, 2000, 500 );

            List<String> joinsView = eng.getDatabaseTables().getJoinsView();
            System.out.println( joinsView );

            return eng;
        } catch( Throwable e ) {
            e.printStackTrace();
            System.exit( 0 );
            return null;
        }
    }

    /**
     * Main method of this sample
     * @param args arguments not used
     */
    public static void main( String[] args ) {
        new Joins().initUI();
    }
}
